Ext.data.JsonP.sol_common_Config({"tagname":"class","name":"sol.common.Config","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.Config.js","href":"lib_sol.common.Config.html#sol-common-Config"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null},{"tagname":"author","name":"NM, ELO Digital Office GmbH","email":null}],"version":["1.06.000"],"elojc":true,"eloas":true,"eloix":true,"requires":["sol.common.IxUtils","sol.common.ObjectUtils","sol.common.RepoUtils","sol.common.UserUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"compose","tagname":"cfg","owner":"sol.common.Config","id":"cfg-compose","meta":{}},{"name":"config","tagname":"cfg","owner":"sol.common.Config","id":"cfg-config","meta":{}},{"name":"copy","tagname":"cfg","owner":"sol.common.Config","id":"cfg-copy","meta":{}},{"name":"exceptionOnBrokenConfig","tagname":"cfg","owner":"sol.common.Config","id":"cfg-exceptionOnBrokenConfig","meta":{}},{"name":"forceReload","tagname":"cfg","owner":"sol.common.Config","id":"cfg-forceReload","meta":{}},{"name":"load","tagname":"cfg","owner":"sol.common.Config","id":"cfg-load","meta":{}},{"name":"merge","tagname":"cfg","owner":"sol.common.Config","id":"cfg-merge","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"writable","tagname":"cfg","owner":"sol.common.Config","id":"cfg-writable","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"CONFIG_PATH","tagname":"property","owner":"sol.common.Config","id":"property-CONFIG_PATH","meta":{"private":true}},{"name":"DEFAULT_BASE_PATHS","tagname":"property","owner":"sol.common.Config","id":"property-DEFAULT_BASE_PATHS","meta":{"private":true}},{"name":"basePaths","tagname":"property","owner":"sol.common.Config","id":"property-basePaths","meta":{"private":true}},{"name":"config","tagname":"property","owner":"sol.common.Config","id":"property-config","meta":{}},{"name":"eloAsPathPattern","tagname":"property","owner":"sol.common.Config","id":"property-eloAsPathPattern","meta":{"private":true}},{"name":"log","tagname":"property","owner":"sol.common.Config","id":"property-log","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"objId","tagname":"property","owner":"sol.common.Config","id":"property-objId","meta":{"private":true}},{"name":"pilcrow","tagname":"property","owner":"sol.common.Config","id":"property-pilcrow","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"getBasePaths","tagname":"method","owner":"sol.common.Config","id":"method-getBasePaths","meta":{"private":true}},{"name":"getCompose","tagname":"method","owner":"sol.common.Config","id":"method-getCompose","meta":{"private":true}},{"name":"getObjId","tagname":"method","owner":"sol.common.Config","id":"method-getObjId","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.Config","id":"method-initialize","meta":{"private":true}},{"name":"isRemote","tagname":"method","owner":"sol.common.Config","id":"method-isRemote","meta":{"private":true}},{"name":"loadEloAsConfig","tagname":"method","owner":"sol.common.Config","id":"method-loadEloAsConfig","meta":{}},{"name":"reload","tagname":"method","owner":"sol.common.Config","id":"method-reload","meta":{}},{"name":"reloadRemote","tagname":"method","owner":"sol.common.Config","id":"method-reloadRemote","meta":{}},{"name":"retrieveComposePath","tagname":"method","owner":"sol.common.Config","id":"method-retrieveComposePath","meta":{}},{"name":"retrieveMergeHierarchy","tagname":"method","owner":"sol.common.Config","id":"method-retrieveMergeHierarchy","meta":{}},{"name":"save","tagname":"method","owner":"sol.common.Config","id":"method-save","meta":{}},{"name":"saveNew","tagname":"method","owner":"sol.common.Config","id":"method-saveNew","meta":{}},{"name":"validForMergeing","tagname":"method","owner":"sol.common.Config","id":"method-validForMergeing","meta":{}}],"code_type":"ext_define","id":"class-sol.common.Config","short_doc":"Helper for JSON configuration files. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.Config</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.IxUtils' rel='sol.common.IxUtils' class='docClass'>sol.common.IxUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.UserUtils' rel='sol.common.UserUtils' class='docClass'>sol.common.UserUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.Config.html#sol-common-Config' target='_blank'>lib_sol.common.Config.js</a></div></pre><div class='doc-contents'><p>Helper for JSON configuration files.</p>\n\n<p>The constructor can take either a <code>load</code>, a <code>compose</code> parameter or a JavaScript object.\nIf the configuration was loaded from the repository (with an additional <code>writable=true</code>) as parameter, all changes can be saved back to the repository with <a href=\"#!/api/sol.common.Config-method-save\" rel=\"sol.common.Config-method-save\" class=\"docClass\">save</a>.\nSaving will always be deactivated if the configuration was loaded with compose.\nIf the instance was constructed with an object, it can be saved as a new repository element with <a href=\"#!/api/sol.common.Config-method-saveNew\" rel=\"sol.common.Config-method-saveNew\" class=\"docClass\">saveNew</a>.</p>\n\n<h1>Load</h1>\n\n<p>This code loads a configuration in readonly mode from a repository file:</p>\n\n<pre><code>var myconfig = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.Config\" rel=\"sol.common.Config\" class=\"docClass\">sol.common.Config</a>\", { load: \"(286B8C55-DBF6-2391-8447-479ED57FFDB0)\" }).config;\n</code></pre>\n\n<p>The next example also loads a configuration, but also saves changed back:</p>\n\n<pre><code>var cfg = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.Config\" rel=\"sol.common.Config\" class=\"docClass\">sol.common.Config</a>\", { load: \"ARCPATH:/Administration/Configuration/MyJsonConfig\", writable: true });\nvar myconfig = cfg.config;\n// ... make some changes to myconfig ...\ncfg.save();\n</code></pre>\n\n<h1>Compose</h1>\n\n<p>If a new configuration object is created using <code>compose</code>,\nit tries to load the original file as well as a customized file from the same path underneath the 'Business Solutions Costom' folder.\nBoth files will be merged, while the changes in the custom file will override the original settings.</p>\n\n<pre><code>var myconfig = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.Config\" rel=\"sol.common.Config\" class=\"docClass\">sol.common.Config</a>\", { compose: \"/contract/Configuration/contract.config\" }).config;\n</code></pre>\n\n<p>If <code>compose</code> is used with an objId, it tries to figure out the relative path inside the Solution folder.\nIf there is none, nothing will be loaded.\nIf there is more then one valid path the first one will be used.</p>\n\n<h1>Config</h1>\n\n<p>To save a new configuration, you could:</p>\n\n<pre><code>var cfg = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.Config\" rel=\"sol.common.Config\" class=\"docClass\">sol.common.Config</a>\", { config: { exampleConfigProperty: \"a String\", anotherProperty: 4711 } });\ncfg.saveNew(\"ARCPATH:/Administration/Configuration/myNewExampleConfig\");\n</code></pre>\n\n<h1>Additional comments</h1>\n\n<p>If used within clients that don't have an ixConnectAdmin-connection configurations are processed by ix function calls.\nThis allows for additional caching among all users and speed up client load times.</p>\n\n<h1>Protected config files</h1>\n\n<p>If a config file contains sensible data (e.g. passwords) it can be secured by adding a <code>$protected</code> property (top level).\nThis ensures that no user can obtain a configuration accidentally from cache, without having access to the file itself.</p>\n      <p class='version-tag'>Version: <b>1.06.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-compose' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-cfg-compose' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-cfg-compose' class='name expandable'>compose</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional) This has to be a relative arcpath underneath the 'Business Solution' folder or a valid objId</p>\n</div><div class='long'><p>(optional) This has to be a relative arcpath underneath the 'Business Solution' folder or a valid objId</p>\n</div></div></div><div id='cfg-config' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-cfg-config' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-cfg-config' class='name expandable'>config</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)</p>\n</div><div class='long'><p>(optional)</p>\n</div></div></div><div id='cfg-copy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-cfg-copy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-cfg-copy' class='name expandable'>copy</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) If true, config-property of initialized class will contain a new object instead of a cache reference. ...</div><div class='long'><p>(optional) If <code>true</code>, <code>config</code>-property of initialized class will contain a new object instead of a cache reference.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-exceptionOnBrokenConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-cfg-exceptionOnBrokenConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-cfg-exceptionOnBrokenConfig' class='name expandable'>exceptionOnBrokenConfig</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) If true the merge function throws an exception if on of the configs (which should be merged) is broken. ...</div><div class='long'><p>(optional) If <code>true</code> the merge function throws an exception if on of the configs (which should be merged) is broken.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-forceReload' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-cfg-forceReload' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-cfg-forceReload' class='name expandable'>forceReload</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) If true cache will be refreshed. ...</div><div class='long'><p>(optional) If <code>true</code> cache will be refreshed.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-load' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-cfg-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-cfg-load' class='name expandable'>load</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional) This can be an objId, GUID or arcpath to checkout a JSON configuration file from the repository.</p>\n</div><div class='long'><p>(optional) This can be an objId, GUID or arcpath to checkout a JSON configuration file from the repository.</p>\n</div></div></div><div id='cfg-merge' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-cfg-merge' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-cfg-merge' class='name expandable'>merge</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nIf true the configuration loaded via load, will be merged (if possible). ...</div><div class='long'><p>(optional)\nIf <code>true</code> the configuration loaded via <code>load</code>, will be merged (if possible).\nThis is only neccessary if constructor is invoked with <code>load</code>, other wise it will be ignored.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-writable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-cfg-writable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-cfg-writable' class='name expandable'>writable</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) If true, the loaded configuration is writable via the save function ...</div><div class='long'><p>(optional) If <code>true</code>, the loaded configuration is writable via the <a href=\"#!/api/sol.common.Config-method-save\" rel=\"sol.common.Config-method-save\" class=\"docClass\">save</a> function</p>\n<p>Defaults to: <code>false</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-CONFIG_PATH' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-property-CONFIG_PATH' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-property-CONFIG_PATH' class='name expandable'>CONFIG_PATH</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E00)]:/Business Solutions/common/Configuration/base.config&quot;</code></p></div></div></div><div id='property-DEFAULT_BASE_PATHS' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-property-DEFAULT_BASE_PATHS' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-property-DEFAULT_BASE_PATHS' class='name expandable'>DEFAULT_BASE_PATHS</a> : String[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[&quot;Business Solutions&quot;, &quot;Business Solutions Custom&quot;]</code></p></div></div></div><div id='property-basePaths' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-property-basePaths' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-property-basePaths' class='name expandable'>basePaths</a> : String[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-config' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-property-config' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-property-config' class='name expandable'>config</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>The loaded (or via constructor initialized) configuration object.</p>\n</div><div class='long'><p>The loaded (or via constructor initialized) configuration object.</p>\n</div></div></div><div id='property-eloAsPathPattern' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-property-eloAsPathPattern' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-property-eloAsPathPattern' class='name expandable'>eloAsPathPattern</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Describes the paths where the loadEloAsConfig function looks for the ELOas configuration (inside the Solution folder) ...</div><div class='long'><p>Describes the paths where the <code>loadEloAsConfig</code> function looks for the ELOas configuration (inside the Solution folder)</p>\n<p>Defaults to: <code>&quot;/{{SOLUTION}}/Configuration/as.config&quot;</code></p></div></div></div><div id='property-log' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-property-log' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-property-log' class='name expandable'>log</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>Internal logger</p>\n</div><div class='long'><p>Internal logger</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-objId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-property-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-property-objId' class='name expandable'>objId</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>Reference to the loaded configuration in the repository</p>\n</div><div class='long'><p>Reference to the loaded configuration in the repository</p>\n</div></div></div><div id='property-pilcrow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-property-pilcrow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-property-pilcrow' class='name expandable'>pilcrow</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;\\u00b6&quot;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-getBasePaths' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-getBasePaths' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-getBasePaths' class='name expandable'>getBasePaths</a>( <span class='pre'></span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the base paths from the common.config.baseMergePaths or uses DEFAULT_BASE_PATHS as fallback. ...</div><div class='long'><p>Retrieves the base paths from the common.config.baseMergePaths or uses <a href=\"#!/api/sol.common.Config-property-DEFAULT_BASE_PATHS\" rel=\"sol.common.Config-property-DEFAULT_BASE_PATHS\" class=\"docClass\">DEFAULT_BASE_PATHS</a> as fallback.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getCompose' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-getCompose' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-getCompose' class='name expandable'>getCompose</a>( <span class='pre'>config</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the compose path from the constructors config object. ...</div><div class='long'><p>Retrieves the compose path from the constructors config object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getObjId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-getObjId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-getObjId' class='name expandable'>getObjId</a>( <span class='pre'>path</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Returns the object ID of a given repository path. ...</div><div class='long'><p>Returns the object ID of a given repository path.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : String<div class='sub-desc'><p>Repository path. The path separator is defined by the first character after \"ARCPATH:\"</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The ID of the new element, or nothing if it does not exist</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-isRemote' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-isRemote' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-isRemote' class='name expandable'>isRemote</a>( <span class='pre'></span> ) : boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>This function identifies if a configuration should be loaded remotely. ...</div><div class='long'><p>This function identifies if a configuration should be loaded remotely.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>boolean</span><div class='sub-desc'><p>true if configuration should load remotely</p>\n</div></li></ul></div></div></div><div id='method-loadEloAsConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-loadEloAsConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-loadEloAsConfig' class='name expandable'>loadEloAsConfig</a>( <span class='pre'>[solution]</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Loads the ELOas configuration. ...</div><div class='long'><p>Loads the ELOas configuration. The filename has to be <code>as.config</code></p>\n\n<p>The <code>as.config</code> file content has to be a valid JSON string with at least the following propperties:</p>\n\n<pre><code>{\n  \"protocol\": \"http\",\n  \"server\": \"myservername\",\n  \"port\": \"8080\",\n  \"name\": \"as-myarchive\"\n}\n</code></pre>\n\n<p>If a <code>solution</code> string is provided, the function tries to lookup a solution specific ELOas configuration.\nIf no specific configuration is found, or no <code>solution</code> string is provied, it falls back to the <code>common</code> configuration.</p>\n\n<p>Lookup path:</p>\n\n<pre><code>\"ARCPATH:/Administration/Business Solutions/{{SOLUTION}}/Configuration/as.config\"\n</code></pre>\n\n<p>Fallback path:</p>\n\n<pre><code>\"ARCPATH:/Administration/Business Solutions/common/Configuration/as.config\"\n</code></pre>\n\n<p>The following examle tries to load an ELOas configuration specific for the 'invoice' solution:</p>\n\n<pre><code>var eloAsConfig = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.Config\" rel=\"sol.common.Config\" class=\"docClass\">sol.common.Config</a>\").loadEloAsConfig(\"invoice\");\n</code></pre>\n\n<p>The result for the configuration file above:</p>\n\n<pre><code>{\n  protocol: \"http\",\n  server: \"myservername\",\n  port: \"8080\",\n  name: \"as-myarchive\"\n}\n</code></pre>\n\n<p>This uses the <a href=\"#!/api/sol.common.ConfigCache\" rel=\"sol.common.ConfigCache\" class=\"docClass\">sol.common.ConfigCache</a>.\nFirst it tries to retrieve a configuration for the solution name.\nIf none was found it attempts to read the configuration from a solution specific file.\nIf there is no solution specific ELOas configuration (neither in cache, nor in the archive),\nit will try to use a cached common configuration or get the one from the archive.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>solution</span> : String (optional)<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-reload' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-reload' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-reload' class='name expandable'>reload</a>( <span class='pre'>[force]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>This function reloads the configuration from the repository, and updates the config property ...</div><div class='long'><p>This function reloads the configuration from the repository, and updates the <code>config</code> property</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>force</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code>, cached configs will be ignored.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></div></div><div id='method-reloadRemote' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-reloadRemote' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-reloadRemote' class='name expandable'>reloadRemote</a>( <span class='pre'>[force]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>This function reloads the configuration from the repository, and updates the config property remotely. ...</div><div class='long'><p>This function reloads the configuration from the repository, and updates the <code>config</code> property remotely. This will allow caching configurations for all users in clients.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>force</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code>, cached configs will be ignored.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></div></div><div id='method-retrieveComposePath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-retrieveComposePath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-retrieveComposePath' class='name expandable'>retrieveComposePath</a>( <span class='pre'>objId</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the relative path for an object, which can be used to compose. ...</div><div class='long'><p>Retrieves the relative path for an object, which can be used to compose.\nIf there is more then one composable path, the first one will be used.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-retrieveMergeHierarchy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-retrieveMergeHierarchy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-retrieveMergeHierarchy' class='name expandable'>retrieveMergeHierarchy</a>( <span class='pre'>[extended]</span> ) : String[]|Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves all configs (objIds) for a given element which would be merged to it. ...</div><div class='long'><p>Retrieves all configs (objIds) for a given element which would be merged to it.</p>\n\n<pre><code>cfg.retrieveMergeHierarchy()   // =&gt; [\"(7AEC9AD9-A487-F472-1C60-24925943A3CB)\"]\n\ncfg.retrieveMergeHierarchy(true)   // =&gt; [{ guid: \"(7AEC9AD9-A487-F472-1C60-24925943A3CB)\", basePath: \"Business Solutions\", arcPath: \"ARCPATH:/...\" }]\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>extended</span> : boolean (optional)<div class='sub-desc'><p>If <code>true</code>, this function returns additional infos.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]|Object[]</span><div class='sub-desc'><p>Array with GUIDs</p>\n</div></li></ul></div></div></div><div id='method-save' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-save' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-save' class='name expandable'>save</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>This function saves changes to the config property to the repository ...</div><div class='long'><p>This function saves changes to the <code>config</code> property to the repository</p>\n<h3 class='pa'>Throws</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Throws an exception, if there is no reference to an repository element (see <a href=\"#!/api/sol.common.Config-property-objId\" rel=\"sol.common.Config-property-objId\" class=\"docClass\">objId</a>)</p>\n</div></li><li><span class='pre'>Object</span><div class='sub-desc'><p>Throws an exception, if the oebjct was created in readonly mode (see <a href=\"#!/api/sol.common.Config-cfg-writable\" rel=\"sol.common.Config-cfg-writable\" class=\"docClass\">writable</a>)</p>\n</div></li></ul></div></div></div><div id='method-saveNew' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-saveNew' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-saveNew' class='name expandable'>saveNew</a>( <span class='pre'>arcPath, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Saves a new configuration file to the repository. ...</div><div class='long'><p>Saves a new configuration file to the repository.</p>\n\n<ul>\n<li><b>The path has to contain the element name</b></li>\n<li><b>The path needs to exist (except for the element name), i.e. no new folders will be created</b></li>\n</ul>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arcPath</span> : String<div class='sub-desc'><p>An repositoty path.</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>connection</span> : de.elo.ix.client.IXConnection<div class='sub-desc'><p>Index server connection</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-validForMergeing' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Config'>sol.common.Config</span><br/><a href='source/lib_sol.common.Config.html#sol-common-Config-method-validForMergeing' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Config-method-validForMergeing' class='name expandable'>validForMergeing</a>( <span class='pre'>[objId]</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if an object is in a valid location, so it can be used for compose mode. ...</div><div class='long'><p>Checks, if an object is in a valid location, so it can be used for <code>compose</code> mode.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String (optional)<div class='sub-desc'><p>If <code>undefined</code> the internal value (from constructor: <code>load</code> or <code>compose</code>) will be used</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true}});